﻿# Overview
Since SAMM 1.5, metrics have been somewhat integrated into the new scoring system.
  * In practice, we don't see manhy people using the success metrics listed for the activities.
    * This may be due to people not understanding what to start measuring and when in order to use them.

**Question**: What types of metrics should we be using in general, how do they fit together.

Metrics can be:
  * application metrics
    * 
  * process metrics: 
    * measures the effectiveness and coverage of a process. Not linked to an application.
    * can include people-processes, e.g. is a team meeting their SLA obligations. 

More generally, both types of metrics can be:
  
  * Primary metrics (aka point in time metrics)
    * As of date X, y metrics apply (e.g. n % of developers have completed training)

  * Secondary, (aka trending metrics over time)
    * in the past X months, we've increased developer training to 60%.
  
As an org matures, it should be able to state that metrics will not drop below a certain point (e.g. dev training should not be lower than 80%)

Can report metrics per app, or over apps (e.g. within a BU).

All metrics will have bvoth individual and aggregate versions.

# Interesting Discussion Points
## breadth vs depth
Current metrics are more breadth directed. They lack depth.
  
  * e.g. everyone has followed the process => 100% coverage. No mention of how good the process actually is.
  * suggestion to add CMMI-like quality measurements to the scoring. Aiming at something like, 80% of staff (breadth) followed a basic training (depth) vs. 40% of staff followed an advanced training (depth).
  
  * breadth vs depth:
    * How many people went through a training process vs how effective was the training
  * The different metrics also tend to map to the people consuming them:
    * operations people are more interested in application specific metrics rather than process ones.
  * some metrics don't clearly fit in app or process.
    * e.g. we notice a drop in vulnerabilties. Is this due to a switch in technology (app) or to more effective training (process).
    * Conclusion: there is a link and overlap between the 2. 

### Depth measurement
  * could consider working with Low, Medium, High to keep it simple.
  * Could consider only adding depth measurements to the in-depth assessments and leaving the out of the lightweight assessments (or, making them optional for those who would nevertheless still like to capture depth).

## Adding an environment metric
  * How to accommodate the notion of an environment. Adding new applications to an existing portfolio would skew the metrics compeltely. There needs to be a way of capturing this and making it explicit to correctly interpret the changes.
    * We may need to add a 3rd category of metrics, **Environment**. 
  * This is most useful in explaining variations in metrics when presenting them in a dashboard. Probably less useful when metrics are used as KPIs (i.e. non-board level reporting) by teams who understand changes in the metrics.

## Estimated effort
  * We dropped it from SAMM 1.5. Is there any point in re-introducing it.
  * The consensus was that it probably varies too much per organisation and that we'd get it wrong more often than not which could put people off following the model.
  * We could look at how Timo represented this in his devops maturity model (difficulty level rather than time estimates).
  * We could use the Dataset project to estimate this. When an organisation is submitting repeated assessments and there is an increase in the score for an activity, ask them to roughly estimate the effort required to achieve it (cost, effort, time). This could allow us to extrapolate (to some degree) estimated effort per organisational profile.
  
## board-level metrics
Board-level want to measure efficiency:

  * how much are you spending on security vs how much are you accomplishing
  * risks matter surprisingly little (too subjective).
    * you have to give them sufficient info to enable them to estimate the risk for themselves.
  * process coverage is important
  * BU engagement is important
  * proactive effort vs reactive
    * proactive: Optimise spending, shows how to save money
    * reactive: Less control over spending. Results in higher costs (feeding back)
    * Caution about whether to use the terms: Is a pentest proactive or reactive? Depends to an extent on where it is performed.
  * peer /industry comparison
  * Objective: demonstrate how to fund the next project. Need to show that funding the previous project was a good investment.

## Misc
  * Focus on things you can measure in each practice
  * Strategic level metrics will be on the Business funtion level

# Conclusions
  * We will explore integrating depth scoring to the model for version 2.0. It will most likely complicate the scoring so it will probably be made optional.
  * Define logical categories of metrics:
    * Application
    * Process
    * **probably environment**
  * remove success metrics. 
  